create or replace function tbicds.getSqlValue (
   pi_vSql                           in varchar2,
   pi_vParameterNameList             in varchar2,
   pi_vParameterValueList            in varchar2
   ) return                             varchar2
AUTHID CURRENT_USER
is
   v_vSql                               varchar2(4000) := pi_vSql;
   rc                                   sys_refcursor;
   v_vParameterNameList                 varchar2(4000) := trim(pi_vParameterNameList)||',';
   v_vParameterValueList                varchar2(4000) := trim(pi_vParameterValueList)||',';
   v_vParameterName                     varchar2(4000);
   v_vParameterValue                    varchar2(4000);
   v_vValue                             varchar2(4000);
   v_nPos                               number;
   
   function getFirst (
      pio_vList                     in out varchar2
      ) return                             varchar2
   is 
      v_vValue                             varchar2(4000);
      v_nPos                               number;
   begin
      v_nPos := instr(pio_vList,',');
      v_vValue := trim(substr(pio_vList, 1, v_nPos-1));
      pio_vList := trim(substr(pio_vList, v_nPos+1));
      return v_vValue;
   end;
   
begin
   while (v_vParameterNameList is not null)
   loop
      v_vParameterName := getFirst(v_vParameterNameList);
      v_vParameterValue := getFirst(v_vParameterValueList);
      v_vParameterValue := ''''||v_vParameterValue||'''';
      v_vSql := replace(v_vSql, v_vParameterName, v_vParameterValue);
   end loop;
   
   open rc for v_vSql;
   fetch rc into v_vValue;
   close rc;
   
   return v_vValue;
exception
   when others
   then
      return null;
end;
/

